
// Example sketch which shows how to display some patterns
// on a 64x64 LED matrix
//

#include "ESP32-HUB75-MatrixPanel-I2S-DMA.h"
#include "bit_bmp.h"

#define PANEL_RES_X 64      // Number of pixels wide of each INDIVIDUAL panel module. 
#define PANEL_RES_Y 64     // Number of pixels tall of each INDIVIDUAL panel module.
#define PANEL_CHAIN 2     // Total number of panels chained one to another
 
//MatrixPanel_I2S_DMA dma_display;
MatrixPanel_I2S_DMA *dma_display = nullptr;

uint16_t myBLACK = dma_display->color565(0, 0, 0);
uint16_t myWHITE = dma_display->color565(255, 255, 255);
uint16_t myRED = dma_display->color565(255, 0, 0);
uint16_t myGREEN = dma_display->color565(0, 255, 0);
uint16_t myBLUE = dma_display->color565(0, 0, 255);



// Input a value 0 to 255 to get a color value.
// The colours are a transition r - g - b - back to r.
// From: https://gist.github.com/davidegironi/3144efdc6d67e5df55438cc3cba613c8
uint16_t colorWheel(uint8_t pos) {
  if(pos < 85) {
    return dma_display->color565(pos * 3, 255 - pos * 3, 0);
  } else if(pos < 170) {
    pos -= 85;
    return dma_display->color565(255 - pos * 3, 0, pos * 3);
  } else {
    pos -= 170;
    return dma_display->color565(0, pos * 3, 255 - pos * 3);
  }
}

void drawText(int colorWheelOffset)
{
  
  // draw text with a rotating colour
  dma_display->setTextSize(1);     // size 1 == 8 pixels high
  dma_display->setTextWrap(false); // Don't wrap at end of line - will do ourselves

  dma_display->setCursor(3, 16);    // start at top left, with 8 pixel of spacing
  uint8_t w = 0;
  const char *str = "FULL-COLOR";
  for (w=0; w<10; w++) {
    dma_display->setTextColor(colorWheel((w*32)+colorWheelOffset));
    dma_display->print(str[w]);
  }
  
  dma_display->setCursor(4, 28);
  dma_display->setTextColor(dma_display->color444(15,15,15));
  dma_display->println("RGB");
  
  dma_display->setCursor(25, 28);
  dma_display->setTextColor(dma_display->color444(15,15,15));
  dma_display->println("MATRIX");

  dma_display->setCursor(9, 40);
  dma_display->setTextColor(dma_display->color444(0,15,15));
  dma_display->print("P");
  dma_display->setTextColor(dma_display->color444(15,0,0));
  dma_display->print('3');
  
  dma_display->setCursor(60, 40);
  // print each letter with a fixed rainbow color
  dma_display->setTextColor(dma_display->color444(0,8,15));
  dma_display->print('6');
  dma_display->setTextColor(dma_display->color444(15,4,0));
  dma_display->print('4');
  dma_display->setTextColor(dma_display->color444(15,15,0));
  dma_display->print('x');
  dma_display->setTextColor(dma_display->color444(8,15,0));
  dma_display->print('6');
  dma_display->setTextColor(dma_display->color444(8,0,15));
  dma_display->print('4');

  // Jump a half character
 


}


void setup() {

  // Module configuration
  HUB75_I2S_CFG mxconfig(
    PANEL_RES_X,   // module width
    PANEL_RES_Y,   // module height
    PANEL_CHAIN    // Chain length
  );

  mxconfig.gpio.e = 32;
  mxconfig.clkphase = false;
  mxconfig.driver = HUB75_I2S_CFG::FM6124;

  // Display Setup
  dma_display = new MatrixPanel_I2S_DMA(mxconfig);
  dma_display->begin();
  dma_display->setBrightness8(90); //0-255
  dma_display->clearScreen();
  dma_display->fillScreen(myWHITE);
  
  // fix the screen with green
  dma_display->fillRect(0, 0, dma_display->width(), dma_display->height(), dma_display->color444(0, 15, 0));
  delay(500);

  // draw a box in yellow
  dma_display->drawRect(0, 0, dma_display->width(), dma_display->height(), dma_display->color444(15, 15, 0));
  delay(500);

  // draw an 'X' in red
  dma_display->drawLine(0, 0, dma_display->width()-1, dma_display->height()-1, dma_display->color444(15, 0, 0));
  dma_display->drawLine(dma_display->width()-1, 0, 0, dma_display->height()-1, dma_display->color444(15, 0, 0));
  delay(500);

  // draw a blue circle
  dma_display->drawCircle(10, 10, 10, dma_display->color444(0, 0, 15));
  delay(500);

  // fill a violet circle
  dma_display->fillCircle(40, 21, 10, dma_display->color444(15, 0, 15));
  delay(500);

  // fill the screen with 'black'
  dma_display->fillScreen(dma_display->color444(0, 0, 0));

  //drawText(0);

}

uint8_t wheelval = 0;
void loop() {
    dma_display->fillScreen(myBLACK);
    dma_display->drawRGBBitmap(20,0,(uint16_t *)Pikachu1_64x64,64,64);
    delay(2000); 
    dma_display->fillScreen(myBLACK);
    dma_display->drawRGBBitmap(20,0,(uint16_t *)Pikachu2_64x64,64,64);
    delay(2000); 
    dma_display->fillScreen(myBLACK);  
    dma_display->drawRGBBitmap(20,0,(uint16_t *)Doraemon_64x64,64,64);
    delay(2000); 
    dma_display->fillScreen(myBLACK);
    dma_display->drawRGBBitmap(0,0,(uint16_t *)Pikachu_128x64,128,64);
    delay(2000); 
    dma_display->fillScreen(myBLACK);
    dma_display->drawRGBBitmap(0,0,(uint16_t *)W_128x64,128,64);
    delay(2000); 
}
